# **Deel Backend Assignment**

**This application is live at [https://mytest.fullstackdev.in/](https://mytest.fullstackdev.in/) and source files can be downloaded from [https://mytest.fullstackdev.in/test.zip](https://mytest.fullstackdev.in/test.zip)**.

Welcome to the Deel Backend Assignment repository. This project demonstrates a high-quality backend solution with a focus on scalability, security, and seamless user interaction. Below, we highlight the cutting-edge features, technical implementations, and value additions to the project.

---

## **🎯 Key Achievements**

### 1. **Concurrency and Consistency via Retry**

- Leveraged advanced retry mechanisms to ensure transactional consistency under high-concurrency scenarios.
- Safeguarded critical operations like deposits and job payments against database contention (e.g., SQLITE_BUSY errors).
- Achieved seamless user experience even under heavy load, ensuring reliability across all endpoints.

### 2. **Comprehensive Code Quality and Coverage**

- **Nearly 100% Test Coverage**: Ensured every module and edge case is covered with extensive unit and integration tests.
- Commands to run tests:
    - Run all tests: `npm run test`
    - Generate test coverage report: `npm run test:coverage`
- **Prettier and Linting**: Maintained clean, readable, and consistent code.
    - Format codebase using Prettier: `npm run format`
    - Check and fix linting errors: `npm run lint`

### 3. **Advanced Concurrency and Transaction Management**
- Leveraged **Sequelize Transactions** with `ISOLATION_LEVELS.REPEATABLE_READ` and `SERIALIZABLE` to maintain **data consistency** in concurrent operations.
- **Deadlock-free implementation**: Ensured reliable updates to balances and job statuses during simultaneous operations.
- Prevented race conditions with optimized database queries.
- **Concurrency Test**: Successfully handled **10,000 concurrent deposit requests** without any failures using advanced pooling and retry mechanisms.

### 4. **Comprehensive API Design**
- Designed and implemented RESTful APIs adhering to **industry standards**.
- Fully documented APIs using **Swagger** for clarity and developer ease:
    - [Swagger Documentation](https://mytest.fullstackdev.in/doc/)
- APIs validated to meet real-world use cases:
    - Fund deposits respecting limits based on unpaid jobs.
    - Payments restricted to authorized users and sufficient balances.
    - Retrieval of the most profitable professions and top clients.

### 5. **Holistic Testing Approach**
- Achieved high test coverage with:
    - **Unit Tests**: Validated individual services and controllers for edge cases.
    - **Functional Tests**: Ensured end-to-end flows worked as intended.
    - **Concurrency Tests**: Simulated high-load scenarios to validate transaction safety.
- Testing Tools:
    - **Jest** for unit and functional tests.
    - **Supertest** for API integration testing.

### 6. **Intuitive HTML UI for API Testing**
- Delivered a **modern and responsive UI** for manual testing of APIs:
    - **Dynamic forms** for all APIs (e.g., job payments, fund deposits).
    - **JWT-based authentication** for secure API access.
    - Real-time display of responses in a user-friendly format.
    - Concurrency testing capabilities with detailed success and failure logs.
- Linked to **Swagger documentation** for reference.

### 7. **Adherence to Clean Code Principles**
- Followed **SOLID Principles** for maintainable, scalable, and extensible code.
- Modular architecture with clear separation of concerns:
    - **Controller Layer**: API routing and request handling.
    - **Service Layer**: Business logic and validations.
    - **Model Layer**: Database management using Sequelize ORM.

---

## **🚀 Features Delivered**

### **Contracts**
- **`GET /contracts`**: Retrieve all non-terminated contracts for a user.
- **`GET /contracts/:id`**: Retrieve a specific contract owned by the authenticated user.

### **Jobs**
- **`GET /jobs/unpaid`**: Fetch all unpaid jobs for active contracts.
- **`POST /jobs/:job_id/pay`**: Pay for a job with authorization and balance validation.

### **Balances**
- **`POST /balances/deposit/:userId`**: Deposit funds into a client’s balance with checks for job limits.
- **Concurrency Test**: Simulated 10,000 deposit requests concurrently, ensuring transactional safety and data consistency.

### **Admin**
- **`GET /admin/best-profession`**: Determine the profession with the highest earnings in a date range.
- **`GET /admin/best-clients`**: Identify the top-paying clients within a date range.

---

## **🖼 HTML UI Features**
The HTML UI is designed to simplify manual API testing. Below is a summary of available features:

1. **Reset Database**:
    - The **Reset Database** button clears and reseeds the database for a fresh start.
2. **Retrieve Non-Terminated Contracts**:
    - The **Retrieve Contract** button fetches active contracts for the logged-in user.
3. **Retrieve Unpaid Jobs**:
    - The **Retrieve Job** button retrieves all unpaid jobs for active contracts associated with the user.
4. **Pay for a Job**:
    - The **Pay Job** card enables users to pay for specific jobs by entering the job ID.
5. **Deposit Money**:
    - Users can deposit funds into a client’s account using the **Deposit Money** card.
6. **Get Best Profession**:
    - The **Best Profession** card allows users to find the top-earning profession within a specified date range.
7. **Get Best Client**:
    - The **Best Client** card helps identify the highest-paying client in a given date range.
8. **Concurrency Test**:
    - The **Concurrency Test** card enables testing of simultaneous deposit requests by specifying the user ID, amount, and number of concurrent requests (up to 10,000).
    - Results are displayed in real-time with detailed success and error logs.
9. **Get Profile Details**:
    - The **Get Profile** card retrieves detailed information about a user, including their current balance, by entering the profile ID.

---

## **📽️ Visual Highlights**
_screenshots of Swagger UI, test results, and HTML._

![Dashboard](./public/images/dashboard.png "Demo Dashboard")
![Swagger](./public/images/jwt.png "Swagger JWT")
![Test](./public/images/test.png "Test Coverage")


---

## **💻 Technologies and Tools**

### Backend
- **Node.js** with **Express.js** for API development.
- **Sequelize ORM** with SQLite for robust database management.
- **JWT** for secure authentication.

### Frontend
- **HTML5** and **CSS3** for a professional and responsive interface.
- Vanilla **JavaScript** for API integration.

### Testing
- **Jest** and **Supertest** for unit, functional, and integration tests.

---

## **⚙️ Installation and Setup**

### Prerequisites
- Install **Node.js** (v18 or later).

### Installation and Setup
1. Download the source files as a ZIP from:
   [https://mytest.fullstackdev.in/test.zip](https://mytest.fullstackdev.in/test.zip)

2. Extract the ZIP file and navigate into the project directory:
   ```bash
   unzip test.zip
   cd <extracted-directory>
   Copy the provided `default.env` file and rename it to `.env` in the project root.
   ```

3. Install dependencies:
   ```bash
   npm install
   ```

4. Seed the database:
   ```bash
   npm run seed
   ```

5. Start the server:
   ```bash
   npm start
   ```

6. Access the **Swagger Documentation** at:
   [https://mytest.fullstackdev.in/doc/](https://mytest.fullstackdev.in/doc/)

---

## **🔧 Testing**

1. Run all tests:
   ```bash
   npm run test
   ```
2. **Concurrency Tests**:
    - Test up to 10,000 concurrent deposit requests using the Concurrency Test card in the HTML UI.
    - View detailed success and failure logs for each request in real-time.

---

## **🌟 Future Enhancements**

- **Concurrency Control**: Implement optimistic and pessimistic concurrency mechanisms to handle high-contention scenarios effectively.
- **Partitioning and Sharding**: Improve database scalability by dividing data into partitions to reduce contention.
- **Work Queues**: Use RabbitMQ or Kafka to serialize conflicting operations for better throughput.
- **Distributed Locks**: Leverage Redis or ZooKeeper to manage distributed concurrency safely.
- **Retry Logic**: Enhance retry mechanisms to handle transient database errors such as `SQLITE_BUSY` efficiently.
- **CQRS**: Adopt Command Query Responsibility Segregation to separate read and write operations for better scalability.
- **Event-Driven Architecture**: Enable real-time updates and modular designs through event-driven patterns.
- **GraphQL Integration**: Add support for flexible and efficient querying with GraphQL.
- **Caching**: Implement caching strategies for frequently accessed data to improve performance.
- **Event Sourcing**: Implement an event-sourcing pattern to track state changes as events, ensuring scalability, auditability, and resilience in high-concurrency environments.

---

Thank you for reviewing this assignment! 🚀



