const { API_PREFIX } = require('../src/config/constants');
const swaggerAutogen = require('swagger-autogen')();

const doc = {
  info: {
    title: 'Deel Backend API',
    description: 'API documentation for the Deel Backend Task',
  },
  host: process.env.SWAGGER_HOST || 'localhost:3001',
  schemes: process.env.SWAGGER_SCHEME ? [process.env.SWAGGER_SCHEME] : ['http'],
  basePath: `${API_PREFIX}`,
  tags: [],
  securityDefinitions: {
    profileIdAuth: {
      type: 'apiKey',
      in: 'header',
      name: process.env.AUTH_HEADER || 'authorization',
      description: 'API key required for authentication',
    },
  },
  security: [
    {
      profileIdAuth: [],
    },
  ],
};

const outputFile = '../swagger_output.json';
const endpointsFiles = [
  '../src/routes/admin.js',
  '../src/routes/contracts.js',
  '../src/routes/jobs.js',
  '../src/routes/balances.js',
];

swaggerAutogen(outputFile, endpointsFiles, doc);
