require('dotenv').config(); // Load environment variables from .env file
const app = require('./src/app');

async function init() {
  const port = process.env.PORT || 3001; // Use the port from the .env file or default to 3001

  try {
    app.listen(port, () => {
      console.log(`Express App Listening on Port ${port}`);
    });
  } catch (error) {
    console.error(`An error occurred: ${error.message}`);
    process.exit(1);
  }
}

init();
