const express = require('express');
const path = require('path');
const swaggerUi = require('swagger-ui-express');
const swaggerFile = require('../swagger_output.json');
const bodyParser = require('body-parser');
const sequelize = require('./db/sequelize');
const models = require('./db/models');
const contractsRouter = require('./routes/contracts');
const jobsRouter = require('./routes/jobs');
const balancesRouter = require('./routes/balances');
const adminRouter = require('./routes/admin');
const authMiddleware = require('./middleware/authMiddleware');
const { API_PREFIX } = require('./config/constants');

const app = express();

// Serve static files
app.use(express.static(path.join(__dirname, '../public')));

app.use(bodyParser.json());
app.set('sequelize', sequelize);
app.set('models', models);

app.get('/', (req, res) => {
  res.sendFile(path.join(__dirname, 'public', 'index.html'));
});
app.use('/doc', swaggerUi.serve, swaggerUi.setup(swaggerFile));

// Apply global middlewares
app.use(authMiddleware);

app.use(`${API_PREFIX}`, contractsRouter);
app.use(`${API_PREFIX}`, jobsRouter);
app.use(`${API_PREFIX}`, balancesRouter);
app.use(`${API_PREFIX}`, adminRouter);

module.exports = app;
