const { Sequelize } = require('sequelize');

const sequelize = new Sequelize(process.env.DB_CONNECTION_STRING, {
  dialect: 'sqlite',
  logging: false,
  pool: {
    max: 30,
    min: 5,
    acquire: 60000,
    idle: 15000,
  },
});

(async () => {
  try {
    await sequelize.authenticate();
    console.log('Database connection established.');

    await sequelize.query('PRAGMA journal_mode = WAL;');
    console.log('SQLite WAL mode enabled.');
  } catch (err) {
    console.error('Unable to connect to the database:', err);
  }
})();

module.exports = sequelize;
