module.exports = (schema) => (req, res, next) => {
  const { error } = schema.validate({
    ...req.query,
    ...req.body,
    ...req.params,
  });

  if (error) {
    return res.status(400).json({ error: error.details[0].message });
  }
  next();
};
