const { Sequelize, Model } = require('sequelize');
const sequelize = require('../db/sequelize');
const Contract = require('./Contract');

class Job extends Model {}

Job.init(
  {
    id: {
      type: Sequelize.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    description: {
      type: Sequelize.TEXT,
      allowNull: false,
    },
    price: {
      type: Sequelize.DECIMAL(12, 2),
      allowNull: false,
    },
    paid: {
      type: Sequelize.BOOLEAN,
      defaultValue: false,
    },
    paymentDate: {
      type: Sequelize.DATE,
    },
  },
  {
    sequelize,
    modelName: 'Job',
    tableName: 'jobs',
    timestamps: true,
  }
);

// Associations
Contract.hasMany(Job);
Job.belongsTo(Contract);

module.exports = Job;
