const Sequelize = require('sequelize');
const ProfileModel = require('./Profile');
const JobModel = require('./Job');
const ContractModel = require('./Contract');

const sequelize = new Sequelize(process.env.DB_CONNECTION_STRING, {
  dialect: 'postgres', // or 'mysql'
  logging: false,
});

const models = {
  Profile: ProfileModel(sequelize, Sequelize.DataTypes),
  Job: JobModel(sequelize, Sequelize.DataTypes),
  Contract: ContractModel(sequelize, Sequelize.DataTypes),
};

Object.keys(models).forEach((modelName) => {
  if (models[modelName].associate) {
    models[modelName].associate(models);
  }
});

models.sequelize = sequelize;
models.Sequelize = Sequelize;

module.exports = models;
