const express = require('express');
const router = express.Router();
const validateRequest = require('../middleware/validateRequest');
const {
  bestProfessionSchema,
  bestClientsSchema,
  jwtSchema,
} = require('../validations/adminValidation');
const adminController = require('../controllers/adminController');

// Routes
router.get(
  '/admin/best-profession',
  validateRequest(bestProfessionSchema),
  adminController.getBestProfession
);

router.get(
  '/admin/best-clients',
  validateRequest(bestClientsSchema),
  adminController.getBestClients
);

router.get('/admin/profile/:profileId', adminController.getProfileDetails);

router.get('/admin/seed', adminController.runSeed);

// ***** JUST FOR TESTING PURPOSE (SHOULD BE REMOVED) ************
router.get(
  '/admin/jwt/:profileId',
  validateRequest(jwtSchema),
  adminController.generateToken
);

module.exports = router;
