const express = require('express');
const router = express.Router();
const validateRequest = require('../middleware/validateRequest');
const { depositSchema } = require('../validations/balancesValidation');
const balancesController = require('../controllers/balancesController');

// Routes
router.post(
  '/balances/deposit/:userId',
  validateRequest(depositSchema),
  balancesController.depositAmount
);

module.exports = router;
