const express = require('express');
const router = express.Router();
const validateRequest = require('../middleware/validateRequest');
const { jobIdSchema } = require('../validations/jobsValidation');
const jobsController = require('../controllers/jobsController');

// Routes
router.get('/jobs/unpaid', jobsController.getUnpaidJobs);

router.post(
  '/jobs/:jobId/pay',
  validateRequest(jobIdSchema),
  jobsController.payForJob
);

module.exports = router;
