const Profile = require('../models/Profile');

/**
 * Fetches the profile by ID from the database.
 *
 * @param {number} profileId - The ID of the profile to retrieve.
 * @returns {Promise<Object|null>} - The retrieved profile or null if not found.
 */
exports.getProfile = async (profileId) => {
  try {
    const profile = await Profile.findByPk(profileId);
    return profile || null;
  } catch (error) {
    console.error(`[getProfile Error]: ${error.message}`);
    return null;
  }
};
