const request = require('supertest');
const app = require('../../src/app');
const { generateToken } = require('../utils/tokenGenerator');
const sequelize = require('../../src/db/sequelize');
const seed = require('../../scripts/seedDb');

const validToken = generateToken(1);

beforeAll(async () => {
  await sequelize.sync({ force: true });
  await seed();
});

describe('Contract Routes', () => {
  it('should fetch all active contracts', async () => {
    const res = await request(app)
      .get('/v1/contracts')
      .set('Authorization', `Bearer ${validToken}`);

    expect(res.statusCode).toBe(200);
    expect(res.body.contracts.length).toBeGreaterThan(0);
    res.body.contracts.forEach((contract) => {
      expect(contract.status).not.toBe('terminated');
    });
  });

  it('should fetch a specific contract by ID', async () => {
    const res = await request(app)
      .get('/v1/contracts/2')
      .set('Authorization', `Bearer ${validToken}`);

    expect(res.statusCode).toBe(200);
    expect(res.body).toHaveProperty('id', 2);
    expect(res.body.ClientId === 1 || res.body.ContractorId === 1).toBe(true);
  });

  it('should return 404 for a non-existing contract ID', async () => {
    const res = await request(app)
      .get('/v1/contracts/999')
      .set('Authorization', `Bearer ${validToken}`);

    expect(res.statusCode).toBe(404);
    expect(res.body).toHaveProperty(
      'error',
      'Contract not found or unauthorized'
    );
  });
});
