const adminService = require('../../src/services/adminService');
const sequelize = require('../../src/db/sequelize');
const seed = require('../../scripts/seedDb');

beforeAll(async () => {
  await sequelize.sync({ force: true });
  await seed();
});

describe('Admin Service', () => {
  it('should fetch the best profession within the date range', async () => {
    const result = await adminService.getBestProfession(
      '2020-08-10',
      '2020-08-17'
    );
    expect(result).toBe('Programmer');
  });

  it('should return null if no data is found for the best profession', async () => {
    const result = await adminService.getBestProfession(
      '2025-01-01',
      '2025-01-31'
    );
    expect(result).toBeNull();
  });

  it('should fetch the best clients within the date range', async () => {
    const result = await adminService.getBestClients(
      '2020-08-10',
      '2020-08-17',
      2
    );
    expect(result.length).toBeGreaterThan(0);
    result.forEach((client) => {
      expect(client).toHaveProperty('id');
      expect(client).toHaveProperty('fullName');
      expect(client).toHaveProperty('paid');
      expect(client.paid).toBeGreaterThan(0);
    });
  });

  it('should return an empty array if no clients are found for the best clients', async () => {
    const result = await adminService.getBestClients(
      '2025-01-01',
      '2025-01-31',
      2
    );
    expect(result).toEqual([]);
  });
});
