const balancesService = require('../../src/services/balancesService');
const sequelize = require('../../src/db/sequelize');
const seed = require('../../scripts/seedDb');

beforeAll(async () => {
  await sequelize.sync({ force: true });
  await seed();
});

describe('Balances Service', () => {
  it('should deposit successfully within the allowed limit', async () => {
    const profileId = 2;
    const userId = 1;
    const amount = 50;

    const result = await balancesService.deposit(userId, amount, profileId);

    expect(result).toBeDefined();
    expect(result.userId).toBe(userId);
    expect(result.newBalance).toBeGreaterThan(0);
    expect(result.maxDeposit).toBeGreaterThan(0);
    expect(result.unpaidJobsSum).toBeGreaterThan(0);
  });

  it('should throw an error if deposit exceeds 25% of unpaid jobs', async () => {
    const profileId = 2;
    const userId = 1;
    const amount = 1000;

    await expect(
      balancesService.deposit(userId, amount, profileId)
    ).rejects.toThrow('Deposit exceeds 25% of unpaid jobs!');
  });

  it('should throw an error if client does not exist', async () => {
    const profileId = 2;
    const userId = 999;
    const amount = 50;

    await expect(
      balancesService.deposit(userId, amount, profileId)
    ).rejects.toThrow('Client not found!');
  });

  it('should throw an error if the user is not a client', async () => {
    const profileId = 2;
    const userId = 6;
    const amount = 100;

    await expect(
      balancesService.deposit(userId, amount, profileId)
    ).rejects.toThrow('Funds can only be deposited into client profiles!');
  });
});
