const profileService = require('../../src/services/profileService');
const sequelize = require('../../src/db/sequelize');
const seed = require('../../scripts/seedDb');

beforeAll(async () => {
  await sequelize.sync({ force: true });
  await seed();
});

describe('Profile Service', () => {
  it('should fetch a profile by valid ID', async () => {
    const profileId = 1;
    const result = await profileService.getProfile(profileId);

    expect(result).toBeDefined();
    expect(result.id).toBe(profileId);
    expect(result.firstName).toBe('Harry');
  });

  it('should return null for a nonexistent profile ID', async () => {
    const profileId = 999;
    const result = await profileService.getProfile(profileId);

    expect(result).toBeNull();
  });
});
